//********************************************************************************
//								     Include
//********************************************************************************
#include "MDSFxx_SFR.h"
#include "XSFR_GLOBAL.h"
#include "Allhex.h"
//********************************************************************************
//								       RAM
//********************************************************************************
xdata 	unsigned int 	ipwm_counter = 0;
xdata	unsigned char	Buzzer_TIMES = 0;
//********************************************************************************
//								   IPWM_Init
//********************************************************************************
#if (dIPWM_MODE == 1)
void IPWM_Init(void){
	IPWM_CTRL = IPWM_MODE;
	IPWM_CTRL = IPWM_DIS;
	
	IPWM_CYC_H = (IPWM_Counter & 0xFF00)>>8;
	IPWM_CYC_L = (IPWM_Counter & 0x00FF);
	
	IPWM_DUTY_H = (PwmDuty & 0xFF00)>>8;
	IPWM_DUTY_L = (PwmDuty & 0x00FF);
	
	FLAG.Buzzer_SW = 1;
	Buzzer_TIMES   = IPWM_TIMES_Init;
	IPWM_RUN_TIME  = IPWM_RUN_TIME_Init;
	IPWM_STOP_TIME = IPWM_STOP_TIME_Init;
}
//********************************************************************************
//								     BUZZER
//********************************************************************************
void Buzzer_Fun(void){
	if(FLAG.Buzzer_SW){
		if(Buzzer_TIMES>0){
			ipwm_counter++;
			if(ipwm_counter<=IPWM_RUN_TIME)
				IPWM_CTRL = IPWM_EN;
			else if(ipwm_counter<=IPWM_RUN_TIME + IPWM_STOP_TIME)
				IPWM_CTRL = IPWM_DIS;
			else{
				ipwm_counter = 0;
				Buzzer_TIMES-=1;
				if(!Buzzer_TIMES){
					FLAG.Buzzer_SW = 0;
				}
			}
		}
	}
}
#endif